/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//That's it for now. Thanks for watching!
float sfract(float n)
{
 	return smoothstep(0.0,1.0,fract(n));//Smooth fraction
}
float rand(vec2 n)
{
	return fract(abs(cos(dot(n,vec2(7.374,9.356)))*8465.54));//Random noise generator
}
float noise(vec2 n)
{
    float h1 = mix(rand(vec2(floor(n.x),floor(n.y))),rand(vec2(ceil(n.x),floor(n.y))),sfract(n.x));
    float h2 = mix(rand(vec2(floor(n.x),ceil(n.y))),rand(vec2(ceil(n.x),ceil(n.y))),sfract(n.x));
	return mix(h1,h2,sfract(n.y));//Smooth noise
}
float texture(vec2 n)
{
 	float total = noise(n/16.0)*0.05+noise(n/32.0)*0.1+
    noise(n/64.0)*0.3+noise(n/128.0)*0.55;
    return total;//Perlin noise
}
void main( void )
{
    vec2 c = gl_FragCoord.xy;//Coordinates
    vec2 offset = vec2(iGlobalTime*64.0,0.0);//Scrolling
    float nv = texture(vec2((c+offset)*4.0))*0.5+0.5;//Perlin noise texturing
    float height = texture(vec2(c.x,0.0)+offset)*noise((vec2(c.x,0.0)+offset)/256.0);//Hill height
    vec3 sky = vec3(1.0)-(c.y/iResolution.y)*vec3(0.9,0.8,0.5);//Sky color
    float cloud = nv*noise(c/64.0+offset/128.0)*noise(c/48.0)*(1.0-sky.b);//Cloud noise
    float d = height*iResolution.y*0.5-gl_FragCoord.y;//Height value (relative to hill)
    float terrain = max(sign(d),0.0);//Terrain multiplier
    float forest = texture((vec2(c.x,0.0)+offset)*8.0)*0.5+0.5;//Adds definite trees
    vec3 tree = (texture(vec2((c+offset)*16.0))*0.5+0.5)*
        clamp(1.0+d/64.0*forest,0.0,1.0)*vec3(0.2,0.7,0.3);//Tree color
    vec3 col = mix(vec3(0.25,0.8,0.35),vec3(0.8,0.6,0.5),clamp(d/16.0-nv*0.5,0.0,1.0));//Ground color
	gl_FragColor = vec4((nv*terrain)*col+mix(sky,tree,tree.g*2.0)*(1.0-terrain)+cloud,1.0);
}